// FreeFiller background (MV3) — clean rebuild
(() => {
  // Create context menus on install/update
  chrome.runtime.onInstalled.addListener(() => {
    try {
      chrome.contextMenus.removeAll(() => {
        try {
          chrome.contextMenus.create({ id: 'ff-capture-entire', title: 'Save ENTIRE form as Rules', contexts: ['all'] });
          chrome.contextMenus.create({ id: 'ff-fill-now', title: 'Fill Now', contexts: ['all'] });
        } catch (e) { __ff_dbg('[FreeFiller] menu err', e); }
      });
    } catch (e) { __ff_dbg('[FreeFiller] menu err (startup)', e); }
  });

  

// === Background debug cache ===
let __FF_BG_DEBUG = false;
(function initDebugCache(){
  try {
    chrome.storage.local.get({ settings: {} }).then(d => {
      try { __FF_BG_DEBUG = !!(d.settings && d.settings.debug); } catch(_) {}
    });
    chrome.storage.onChanged.addListener((changes, area) => {
      if (area !== 'local') return;
      try {
        if (changes.settings) {
          const s = changes.settings.newValue || {};
          __FF_BG_DEBUG = !!s.debug;
        }
      } catch(_){}
    });
  } catch(_){}
})();

function __ff_dbg(){ if (!__FF_BG_DEBUG) return; try { console.log.apply(console, arguments); } catch(_) {} }

// ENTIRE capture across all frames
  async function fCaptureEntireAllFrames(tab) {
    const d = await chrome.storage.local.get({ settings: {}, rules: [], activeProfileId: 'personal', recentRuleTimestamps: {} });
    const includePw = !!(d.settings && d.settings.includePwEntire);
    const results = await chrome.scripting.executeScript({
      target: { tabId: tab.id, allFrames: true },
      func: (includePw) => {
        try {
          if (window.FreeFiller && FreeFiller.captureEntirePageSide) {
            return FreeFiller.captureEntirePageSide(includePw);
          }
        } catch (e) { return { ok:false, reason:String(e && e.message || e) }; }
        return { ok:false, reason:'capture fn missing' };
      },
      args: [includePw]
    });

    const items = [];
    for (const r of (results || [])) {
      try {
        const out = r && (r.result ?? r);
        if (out && out.ok && Array.isArray(out.rules)) items.push(...out.rules);
      } catch (_) {}
    }

    if (items.length === 0) {
      chrome.notifications?.create('', { type:'basic', iconUrl:'icons/128.png',
        title:'FreeFiller', message:'No fields found in any frame.' });
      return { ok:false, count:0 };
    }

    const url = new URL(tab.url || 'http://local/');
    const siteGlob = `${url.protocol}//${url.hostname}/*`;
    const profileId = d.activeProfileId || 'personal';

    // Overwrite existing rules for this profile + siteGlob
    const baseRules = Array.isArray(d.rules) ? d.rules : [];
    const kept = baseRules.filter(r => !(r && r.profileId === profileId && r.siteGlob === siteGlob));

    const now = Date.now();
    const toAdd = items.map(it => ({
      id: (crypto?.randomUUID?.() || (Math.random().toString(36).slice(2) + '-' + now)),
      siteGlob,
      selector: it.selector || '',
      value: it.value || '',
      profileId
    }));
    const rules = kept.concat(toAdd);

    // Mark as recent
    const rec = Object.assign({}, d.recentRuleTimestamps || {});
    for (const r of toAdd) rec[r.id] = now;

    await chrome.storage.local.set({ rules, recentRuleTimestamps: rec }); try { chrome.runtime.sendMessage({ type: "FF_RULES_UPDATED" }); } catch(_) {} ;
    chrome.notifications?.create('', { type:'basic', iconUrl:'icons/128.png',
      title:'FreeFiller', message:`Saved ${items.length} field(s) for ${siteGlob}.` });
    __ff_dbg('[FreeFiller] ENTIRE saved', items.length, 'fields for', siteGlob);
    return { ok:true, count: items.length };
  }

  // Context menu click handler
  chrome.contextMenus.onClicked.addListener(async (info, tab) => {
    try {
      if (!tab || !tab.id) return;
      if (info.menuItemId === 'ff-capture-entire') {
        await fCaptureEntireAllFrames(tab);
      }
      if (info.menuItemId === 'ff-fill-now') {
        try {
          const [active] = await chrome.tabs.query({ active: true, lastFocusedWindow: true });
          if (active && active.id) {
            chrome.tabs.sendMessage(active.id, { type: "FF_FILL_NOW" }, () => void chrome.runtime.lastError);
          }
        } catch (_) {}
      }
    } catch (e) { console.warn('[FreeFiller] contextMenus.onClicked error', e); }
  });

  // Keyboard command: Fill Now
  chrome.commands.onCommand.addListener(async (command) => {
    if (command !== "fill-now") return;
    try {
      const [tab] = await chrome.tabs.query({ active: true, lastFocusedWindow: true });
      if (tab && tab.id) {
        chrome.tabs.sendMessage(tab.id, { type: "FF_FILL_NOW" }, () => void chrome.runtime.lastError);
      }
    } catch (e) { __ff_dbg('[FreeFiller] commands onCommand error', e); }
  });
})();
