All notable changes to this project are documented here.
Format follows [Keep a Changelog](https://keepachangelog.com/) style.

---

_All notable changes to **FreeFiller** / Most recent to older versions_
_Current version avalable for download: **[1.4.72.2] — 2025-09-02**_

## Notes
- **Auto-fill on load** is smarter in 1.4.x (retry + short watcher) for tricky login pages.
- **ENTIRE capture** only bumps recency for captured rules (using merged IDs).
- **Edit-lock** prevents jumping while editing; blur saves and (optionally) floats updated rules.

## [1.4.72.3] — 2025-09-02 - Compact header spacing - WORKING
### Tweak
- Reduced vertical padding in the sticky header and tightened the Tip/Editing row.
  - This is added to options.js instead of other places it should go. Also the actual Tip/Edit text is in here too and still orphaned inside the option.html and needs to be removed.
  - `header { padding-top: 6px !important; padding-bottom: 0px !important; }`
  - `#editStatus { margin-bottom: 0px !important; margin-top: 2px !important; line-height: 1.25; }`

## [1.4.72.2] — 2025-09-01 - Header banner placement
### Changed
- Tip/Editing banner is now **left‑aligned and full‑width under the title** inside the original sticky header.
### Implementation
- Injected a tiny header CSS: `flex-wrap: wrap` on the header and `#editStatus{flex-basis:100%}` so it always drops to the next line.
\n## 1.4.72.1 — 2025-09-01 - Tip/Editing in original header (green)
### Changed
- Moved the Tip/Editing banner **into the original sticky header** (below logo + “FreeFiller Options”).
- Preserved the **green** styling by using the existing `#editStatus` CSS (`.msg-idle/.msg-active`, `.status-label`).
### Cleanup
- Removed the temporary custom top bar if it existed.
\n## 1.4.72 — 2025-09-01 - Sticky Tip/Editing banner
### Added
- A **floating top bar** on the Options page shows the Tip/Editing status **at all times** (sticky at top while scrolling).
### Details
- Reuses existing `#editStatus` (or creates it), and shows “Editing…” while typing, “Tip:” otherwise.
- Lightweight CSS injected via `<style id="ffTopBarCSS">`; no layout flicker.

## [1.4.70.1] — 2025-09-01 - Tip banner resiliency - WORKING!
### Fixed
- Tip banner occasionally stuck on “Tip:” after long edits: added a lightweight **sync** that keeps the banner aligned with the edit guard even if an event is missed or the DOM re-renders.
### Details
- `__ff_syncEditBanner()` runs on interval (1.5s) and on tab visibility restore; no extra storage reads.

## [1.4.70] — 2025-09-01 - WORKING
### Stable
- Options: **pause while editing** (auto-refresh & “Recent” auto‑aging) with idempotent edit guard.
- Tip banner now toggles between **Editing… (paused)** and **Tip: Changes save…** reliably. **TIP NOT RELIABLY WORKING**
- Auto‑aging “Recent” labels update every 60s and disappear after the window.
- Background logs gated by Debug (from earlier 1.4.69 line).

## [1.4.69.23] — 2025-09-01 - Options tip state
### Fixed
- The edit tip now **toggles correctly**: shows “Editing… List order is PAUSED…” while typing, and returns to the standard “Tip:” once you click outside the field.
### Details
- `editStatus` element gets `.active` on focus/typing; it’s removed on blur or when the edit guard fully unlocks.

## [1.4.69.22] — 2025-09-01 - Recent badges guard
### Fixed
- Auto-aging refresh now skips while editing (`__ff_refreshRecentBadges` checks the edit guard).

## [1.4.69.21] — 2025-09-01 - Options guard (clean rebuild)
### Fixed
- Replaced legacy “Edit Lock” block with a clean, idempotent editing guard.
- Guarded auto-refresh & auto-aging with `typeof ffIsEditing` checks.
### Note
- Based on stable 1.4.69.16 code to avoid earlier merge corruption.

## [1.4.69.16] — 2025-09-01 - Options editing guard
### Added
- Options now **pauses all auto-refresh and auto-aging** while you're typing or focused in an editable field.
- When you leave the field, any pending refresh runs once (debounced), so edits aren’t interrupted.

## [1.4.69.15] — 2025-09-01 - Polish trio
### Added
- Options: **auto-aging** for “Recent” badges (updates every 60s; removes badge when window expires; no storage reads).

### Improved
- Background: **cached Debug** setting (`settings.debug`) with `__ff_dbg(...)` helper; avoids repeated storage reads and gates routine logs.

### Existing
- Options: **Clean duplicates** button already available (groups by Site Glob + selector + profile).

## [1.4.69.14] — 2025-09-01 - Options DOM fix - WORKING - BUGGED OPTION PAGE UPDATES WHEN EDITING
### Fixed
- Restored synchronous DOM builder functions (`renderRuleRow`, `input`, `cell`, `delCell`) so `appendChild` always receives a real Node.

## [1.4.69.13] — 2025-09-01 - Options parse fix
### Fixed
- Removed duplicate `async` tokens and normalized function declarations in `options.js` to prevent `Unexpected token 'async'`.

## [1.4.69.12] — 2025-09-01 - Live Options refresh
### Added
- Options auto-refreshes on `chrome.storage` changes, on tab visibility restore, and when background broadcasts `FF_RULES_UPDATED`.

### Fixed
- Marked several Options functions `async` where `await` is used to avoid parser edge-cases.

## [1.4.69.11] — 2025-09-01 - Background rebuild - WORKING
- Rewrote background.js cleanly (menus, ENTIRE save overwrite+recent, hotkey).

## [1.4.69.10] — 2025-09-01 - Cleaned context-menu listener
### Fixed
- Removed duplicated/malformed `onClicked` handlers and installed a single clean async listener.

## [1.4.69.9] — 2025-09-01 - ENTIRE capture listener fix
### Fixed
- Clean async onClicked handler for "Save ENTIRE form": removed duplicate catch and invalid `await` in non-async callback.

## [1.4.69.8] — 2025-09-01 - ENTIRE save: overwrite & recent
- Overwrite rules for the same Site Glob + profile (no duplicates).
- Mark saved rules as recent so they show the badge.

## [1.4.69.7] — 2025-09-01 - Parse fix
### Fixed
- Balanced IIFE wrappers and removed an extra brace so `content.js` parses cleanly again.

## [1.4.69.6] — 2025-09-01 - Syntax fix
### Fixed
- Cleaned `fillNow` implementation and removed a duplicated tail that caused `Unexpected token 'catch'` at runtime.

## [1.4.69.5] — 2025-09-01 - Privacy & robustness
### Changed
- Moved de-dupe state off `window` into module scope (not page-accessible).
- Password targets are now recorded as **length only** (`len:N`)—no raw password values stored.
- Fill capture now uses `CSS.escape` for `[name="..."]` selectors to handle special characters.
- Fill-in-progress flag now **always resets** via `try/finally`, even on errors.

## [1.4.69.4] — 2025-09-01 - Quiet logs
### Changed
- De-dupe and hotkey logs now only appear when **Debug** is ON.
- Background service worker logs are also gated behind the Debug setting.

## [1.4.69.3] — 2025-09-01 - Value-match de-dupe
### Added
- Skips a new fill if all last-target fields still contain the same values (even after the time window).
- Captures target selector/value pairs during fill via `safeSetValue()`.

## [1.4.69 to 1.4.69.2] — 2025-09-01 - De-dupe window
### Changed
- De-dupe window increased to **2.5s** and keyed on **fill start** time to reliably skip rapid retriggers.
- De-dupe logs now use `console.log` so they’re visible without enabling Verbose logs.

## [1.4.59 to 1.4.68] — 2025-09-01 - UI cleanup/HOTKEY FIX
### Changed
- Popup: added extra space below “Open Options” button.
- Popup: added breathing room under the Profile dropdown (margin-bottom).
- Popup: button now shows the hotkey — “Fill Now (Ctrl-Shift-F)”.

### Fixed
- Hotkey handler now calls the same routine as the popup button: `FreeFiller.fillNow()`.

### Improved
- Added clear console logs for the hotkey pipeline:
- Background: logs when the command triggers and warns on sendMessage issues.
- Content script: logs “Hotkey received (FF_FILL_NOW)” in the page console.

### Added
- Time-based de-dupe: ignore a fill re-triggered within 750ms on the same page.
- Value-based de-dupe: skip fill if prior targets still match their values in the DOM.
- Reliable keyboard shortcut for “Fill Now”: Ctrl+Shift+F (Windows/Linux), Command+Shift+F (macOS).

## [1.4.58] — 2025-09-01
### Removed
- Disabled keyboard shortcut (Alt+Shift+F) and all references to it, since it wasn’t reliably triggering fills.

### Changed
- Manifest no longer declares a `commands` section; background no longer listens for `chrome.commands`.

## [1.4.57] — 2025-09-01
### Fixed
- Resolved a stray closing brace/duplicate lines after `enableAutoSave()` that could trigger `Unexpected token '}'` in some pages.
- Cleaned up a duplicate `enableAutoSave` block and ensured balanced braces around the new debounced autosave implementation.

## [1.4.56] — 2025-09-01
### Changed
- Autosave now stores data in extension storage (`chrome.storage.local`) keyed by origin with debounce, instead of page `localStorage`.

### Added
- Background migration for legacy `framePath` values on update: path-like values reset to empty (treated as “any frame”) to preserve behavior.

### Security
- Prevents websites from reading autosaved content by avoiding page `localStorage`.

## [1.4.55] — 2025-09-01
### Changed
- MV3 service worker hardened (module type + guarded init).
- Content script remains <all_urls>/all_frames/match_about_blank; added web_accessible_resources.

### Added
- Frame-aware rule matching via stable frame index path.
- URL glob matching now works with and without #hash.
- Heuristic selector fallback (id/name/placeholder/aria/label).

### Fixed
- Debug logging sanitizes sensitive values and truncates long strings.
- Prevented SW registration failures by removing top-level throws.

## [1.4.54] — 2025-09-01
### Changed
- Popup “Profile” toolbar now matches the Options page color theme (same background, borders, and text).
- Checkboxes in the popup use a blue accent for better visibility.
- “Profile” dropdown in the popup now has a crisp white border and focus ring for accessibility.

### Fixed
- Consistent theming variables in the popup to prevent regressions when editing colors.

## [1.4.53] — 2025-09-01
### Added
- Page-side `fillNow()` so the context-menu action works on every page.
- CSS.escape fallback to prevent capture crashes in embedded/older environments.

### Fixed
- ENTIRE capture respects “Include passwords” setting (no longer forces passwords).
- ENTIRE capture collects all eligible fields (removed login-only 4-field cap).
- Filling defaults to safe `input` + `blur` and skips `change` unless the rule sets `forceChange: true`.

### Changed
- Updated various `tip` text to better explain Rules moving when `Float recently matched` is checked.
- Selector generator prefers stable attributes before `:nth-of-type()` for better resilience.

## [1.4.52] — 2025-09-01
### Added
- Multi-frame ENTIRE-form capture: background executes across **all frames** in the tab, aggregates results, and saves them as rules.
- Desktop notification confirms ENTIRE capture and shows how many fields were saved.
- Default `siteGlob` for new rules set to `protocol//host/*` of the active tab.
- Light `MutationObserver` in `content.js` to capture dynamically inserted fields (e.g., ExtJS apps).
- Rule option `forceChange: true` to allow dispatching `change` when explicitly needed.

### Fixed
- Autofill no longer fires site `onchange` handlers like `go_to_related_page()` / `expand_menu_tree()` that crash on ExtJS frames (`top.Ext.getCmp(...)` undefined).
- Eliminated silent ENTIRE capture failures on framed pages by ensuring results from **all frames** are merged.
- Capture no longer depends on right-clicking the “correct” frame; works reliably across nested frames.
- Checkbox/radio fill stabilized: no longer double-fires `change` events unless forced.
- Select (multi) fill stabilized: `input` dispatched by default, `change` only if `forceChange`.

### Changed
- `setValue()` unified with `safeSetValue()` for all fill operations:
- Dispatches only `input` + `blur` by default.
- Skips `change` unless rule explicitly sets `forceChange: true`.
- Detects risky inline `onchange` handlers referencing `top.*` and suppresses them.
- Context-menu **“Save ENTIRE form as Rules”** now calls the new background aggregator instead of page-local capture.
- ENTIRE-form capture no longer ignores password clusters in frames — now aggregated consistently across the page.
- Preserved earlier fixes (1.4.49+): frame-aware capture, login heuristics, namespacing, parse-stability patches.

## [1.4.50] — 2025-09-01
### Fixed
- Robust multi-frame ENTIRE-form capture.
- Background orchestrates per-frame collection and merges results.
- Content script replies with frame-local fields.
- Safer fill for apps with fragile onchange handlers (e.g., ExtJS/frameset UIs).
- Avoid synthetic 'change' by default; now dispatches 'input' + 'blur' only.
- Skip 'change' entirely on elements whose onchange references top.* or navigation helpers.
- Add optional rule flag `forceChange: true` to opt in when a site truly needs it.
- Improvement: Light MutationObserver to capture dynamically inserted fields (ExtJS).
- Notes: Manifest already had `all_frames` + `match_about_blank`; kept unchanged.

## [1.4.49] — 2025-09-01
### Added
- Context-click tracker to scope capture to the exact element you clicked.
- Login-aware capture heuristics in `page_captureEntire`: prioritize password field cluster and nearby username input, ignore navigation selects (e.g., `#100`).
- Inject into about:blank/data: frames with `match_about_blank: true`.
- Capture stores `framePath` and fill filters by it so rules only apply in the correct frame.
### Fixed
- Eliminated background parse errors by fully resetting `background.js` to a minimal bridge (no top-level returns/braces).
- Removed any remaining top-level heuristic code and returns in `background.js` to stop parse errors.
- Repaired `content.js` SyntaxError caused by an over‑zealous regex patch that altered a function declaration.
- Resolved `Unexpected token '}'` by rewriting neutralized top-level returns to `void 0;`.
- Removed stray top-level `return` statements in `background.js` (causing “Illegal return statement”). These are now neutralized safely.
- Removed duplicate heuristic injections and replaced with a single block-scoped IIFE in `page_captureEntire()` to avoid `ffForm`/`form` redeclarations.
- Eliminated duplicate `form` declaration in `background.js` by namespacing our injected variables (`ffForm`, `ffScope`, `ffCandidates`).
- ENTIRE-form capture no longer grabs the menu `<select id="100">` on framed pages; focuses on username/password.\n
- Background error `canInject is not defined` by providing a defensive helper when missing.
- Context‑menu capture/fill now strictly target the clicked frame; avoided capturing iframes/frames as fields.
### Changed
- Kept minimal background bridge and page-side capture improvements.
- All capture logic runs in `content.js`; background only dispatches.
- Moved ENTIRE-form capture logic into `content.js` (page-side). `background.js` now only bridges to the page via `chrome.scripting.executeScript`.
- Switched to a safe *wrapper* for `findBySelectorOrRegex(...)` to apply frame filtering without touching original source.
- Capture uses `window.__FF_CAPTURE_CANDIDATES__` for safer handoff to the rest of the logic.
- Safer URL gating: prevents injection into browser-internal pages while allowing `about:blank` frames per 1.4.38.
### Changed
- Rebuilt package for delivery; preserved 1.4.41+ fixes (frame-aware capture, login heuristics, namespacing).

## [1.4.37] — 2025-09-01
### Added
- Frame‑aware execution: content scripts now inject into **all frames**; context‑menu capture/fill target the **clicked frame** via `frameId`.
- Shadow DOM support end‑to‑end: capture now records deep selectors using `>>>`, and filling resolves them via a new deep query engine.
- ENTIRE-form capture now includes `contenteditable` fields and reliably collects inputs rendered inside Shadow DOM and iframes.
- Multi-select support: captured values are stored as `value1|;|value2`, and filling sets `selected` accordingly.
### Fixed
- Pages where login lives inside an iframe/frameset now capture and fill reliably.
- Cases where ENTIRE-form capture missed fields in SPA UIs without a `<form>` wrapper.
- Occasional failures when a field had no `name` and no unique `id` (we now produce a stable selector).
### Changed
- Checkbox/radio values are stored as `'true'/'false'` (backward-compatible with older `'__CHECKED__'` values).
- Selector generator is more robust (prefers unique `id`, falls back to `[name]`, `[type]`, `[value]`, and `:nth-of-type()`).
- Manifest: ensured `host_permissions: ["<all_urls>"]` for consistent capture within cross-origin iframes on user gesture.
### Notes
- Prep for optional `frameUrlPattern` per rule to handle identical selectors across frames.

## [1.4.35] — 2025-09-01
### Fixed
- Capture now scans **all frames** and picks the one with the most inputs. This fixes 0-rule saves on sites that embed login forms in iframes.

## [1.4.34] — 2025-09-01
### Fixed
- Context menu “Save Entire Form” now captures inputs even on pages without a `<form>`.
- Improved selector generation and CSS.escape fallback.
- Tweaks to import option for Lighting Autofill CSV files.

## [1.4.33] — 2025-09-01
### Fixed
- Rules now apply even if a rule's profileId doesn't match an empty/missing active profile.
- "Add Rule" default siteGlob uses `*://*/*` (works on any site); you can narrow it later.

## [1.4.32] — 2025-09-01
### Added
- Robust auto-fill for SPA/device logins that render inputs late (smart retries + short-lived DOM watcher).
- Global keyboard shortcut: **Alt+Shift+F** triggers **Fill Now** on the active tab.
- Options page **edit-lock**: prevents the list from re-sorting while you type; changes save on blur.
- Persistent status bar that explains blur-to-save; labels styled to match the **Recent** tag.
- “**Show rule IDs (debug)**” toggle with a short ID, full-ID tooltip, and **Copy** button.
### Fixed
- “Save ENTIRE Form as Rules” now stamps **only captured rules** as recent, using **merged** rule IDs (no mass bumps).
- Fallback hashing for rules without IDs so **Recent** tracking never drops an entry.
- Startup hygiene: prune invalid timestamps and very old orphaned IDs.

## [1.4.31] — 2025-08-24
### Changed
- Safer merging of `recentRuleTimestamps`; background job prunes stale/non-numeric entries.
- Options auto-refreshes **Recent** badges when storage changes.
### Fixed
- Schema guardrails: backfill IDs for legacy rules where missing.

## [1.4.30] — 2025-08-08
### Added
- Import option for Lighting Autofill CSV files.
- Lightweight table virtualization in Options for large rule sets (2k+ rows).
- **Copy value** buttons in the Value column.
### Changed
- Faster per-profile filters; reduced reflow cost on search.

## [1.4.26] — 2025-07-10
### Changed
- Import: stronger duplicate detection using `(siteGlob, selector, profileId)` key.
- Export: includes profile names in bundle metadata.

## [1.4.24] — 2025-06-22
### Changed
- Dark theme contrast for badges and tooltips.
- Small spacing/keyboard-nav tweaks in Options.

## [1.4.22] — 2025-06-10
### Fixed
- Avoid double-filling when sites re-insert inputs during hydration.
- More tolerant selector resolution when iframes/shadow-roots are present.

## [1.4.20] — 2025-06-03
### Changed
- Popup renders faster (first paint typically <30ms).
- **Fill Now** respects site-glob precedence when multiple profiles match.

## [1.4.18] — 2025-05-22
### Fixed
- Don’t overwrite values while the page’s own scripts are still typing; waits for idle.

## [1.4.16] — 2025-05-10
### Added
- Option to turn off **float recent** sorting.

## [1.4.12] — 2025-04-15
### Added
- **Match preview** in Options: paste a URL to see which rules would apply.
- Badge tooltips show **“Used: _local time_”**.

## [1.4.8] — 2025-03-21
### Fixed
- Race where auto-fill ran before DOM fields existed on some login pages.

## [1.4.5] — 2025-03-03
### Changed
- Smoother scrolling and column widths in Options.

## [1.4.0] — 2025-02-10
### Added
- **Recent** badges and timestamps.
- Site-glob helpers + “Loosen to `https://host/*`” button.

## [1.3.5] — 2024-12-18
### Changed
- ENTIRE-form capture merges into existing rules, preserving their IDs/recency.
- Profile switcher added to the table.

## [1.3.2] — 2024-12-02
### Fixed
- Correctly retain profile filters when navigating between tabs in Options.

## [1.3.0] — 2024-11-21
### Added
- **Profiles**: group rules by context (Work, Personal, etc.).
- Arrow-key navigation across cells in Options.

## [1.2.9] — 2024-10-28
### Fixed
- More reliable fills through shadow-DOM wrappers and custom elements.

## [1.2.7] — 2024-10-07
### Changed
- Optional **auto-save** for snippets; reduced storage writes.

## [1.2.4] — 2024-09-10
### Changed
- Import warns on unknown fields but continues (best-effort ingestion).

## [1.2.2] — 2024-08-29
### Fixed
- Race in content script attach on pages with very early redirects.

## [1.2.0] — 2024-08-20
### Added
- Capture overlay for single-field capture; delay typing detection to avoid fighting page scripts.

## [1.1.8] — 2024-07-22
### Changed
- Popup re-order: **Fill Now** up top; shows active profile & match count.

## [1.1.5] — 2024-06-17
### Added
- Rule search/filter in Options (by site/selector/value).

## [1.1.2] — 2024-06-03
### Fixed
- Prevent accidental duplicate rules when pasting into multiple cells rapidly.

## [1.1.0] — 2024-05-20
### Added
- **Snippets**: reusable text blocks for values.
- **CSV/JSON import & export** with dedupe.

## [1.0.6] — 2024-05-01
### Changed
- Site globs accept `http(s)://host/*` and `*://*.domain.tld/*`.
- Content script runs after `DOMContentLoaded` and again when inputs appear.

## [1.0.3] — 2024-04-09
### Added
- Popup **Fill Now** button.
- First pass at keyboard shortcut hinting.

## [1.0.0] — 2024-03-12
### Added
- Initial release: rule engine (site glob + CSS selector → value), manual Fill, basic Options table.