

// === FreeFiller internal (module-scope, not on window) ===
let FF_LAST = { t: 0, href: "", targets: [] };
let FF_LAST_START = { t: 0, href: "" };
let FF_IS_FILLING = false;
let FF_LAST_TARGETS = [];
// === Polyfills ===
/* FF_CSS_ESCAPE_POLYFILL */
if (!window.CSS) window.CSS = {};
if (typeof CSS.escape !== 'function') {
  CSS.escape = (s) => String(s).replace(/[^a-zA-Z0-9_\-]/g, ch => `\\${ch}`);
}



// === Helpers injected by v1.4.55 ===
function __ff_getFramePath(w=window){
  try {
    const path=[];
    let f=w;
    for (let guard=0; guard<32 && f !== f.parent; guard++){
      let idx = -1;
      try {
        const pf = f.parent;
        const len = pf.frames.length;
        for (let i=0;i<len;i++){ if (pf.frames[i] === f){ idx=i; break; } }
      } catch(e) { idx = -1; }
      path.push(String(idx));
      f = f.parent;
    }
    return path.reverse().join('.');
  } catch(e) { return ''; }
}

function __ff_normalizeUrlForMatch(href, includeHash=true){
  try {
    const u = new URL(href, location.href);
    const base = `${u.protocol}//${u.host}${u.pathname}${u.search}`;
    return includeHash ? base + u.hash : base;
  } catch(e) { return String(href||''); }
}

// sanitize values when debugging
function __ff_safeLogArg(v){
  try {
    if (typeof v === 'string') return v.length > 120 ? v.slice(0,120) + '…' : v;
    if (v && typeof v === 'object') {
      const c = Array.isArray(v) ? v.slice(0,3) : { ...v };
      if ('value' in c) c.value = '••••';
      return c;
    }
    return v;
  } catch(e) {}
  return v;
}

// === Safe setter: default to input+blur; 'change' only if forced ===
function safeSetValue(el, value, opts={}){
  // Capture targets for value-match de-dupe
  try {
    if (FF_IS_FILLING) {
      let sel = null;
      try {
        if (el && el.id) sel = '#' + CSS.escape(el.id);
        else if (el && el.name) sel = (el.tagName ? el.tagName.toLowerCase() : 'input') + '[name="' + CSS.escape(el.name) + '"]';
      } catch(_) {}
      if (!sel) {
        try {
          const name = (el && el.getAttribute) ? el.getAttribute('name') : null;
          if (name) sel = (el.tagName ? el.tagName.toLowerCase() : 'input') + '[name="' + name.replace(/"/g,'\\"') + '"]';
        } catch(_) {}
      }
      if (sel) {
        const recVal = (el && (el.type === 'checkbox' || el.type === 'radio')) ? (value ? 'true' : 'false') : String(value ?? '');
        (FF_LAST_TARGETS = FF_LAST_TARGETS || []).push({ selector: sel, value: recVal });
      }
    }
  } catch(_) {}

  try {
    if (!el) return;
    if (el.tagName === 'SELECT' && el.multiple) {
      const vals = String(value ?? '').split('|;|').map(s => s.trim());
      Array.from(el.options).forEach(o => { o.selected = vals.includes(String(o.value)); });
      el.dispatchEvent(new Event('input', { bubbles:true }));
      if (opts.forceChange) el.dispatchEvent(new Event('change', { bubbles:true }));
      return;
    }
    if ('value' in el) {
      el.value = value ?? '';
      el.dispatchEvent(new Event('input', { bubbles:true }));
      el.dispatchEvent(new Event('blur', { bubbles:true }));
      const oc = (el.getAttribute && el.getAttribute('onchange')) || '';
      const risky = oc && /top\.|go_to_related_page|expand_menu_tree/.test(oc);
      if (opts.forceChange && !risky) {
        el.dispatchEvent(new Event('change', { bubbles:true }));
      }
    } else if (el.isContentEditable) {
      el.textContent = value ?? '';
      el.dispatchEvent(new Event('input', { bubbles:true }));
    }
  } catch(e){ console.warn('[FreeFiller] safeSetValue failed', e); }
}
// === FreeFiller: page-side ENTIRE-form capture ===
(function(){
  if (!window.FreeFiller) window.FreeFiller = {};
  if (!FreeFiller.captureEntirePageSide) {
    FreeFiller.captureEntirePageSide = function(includePw) {
      try {
        const seed = (window.__FF_LAST_RC_EL instanceof Element) ? window.__FF_LAST_RC_EL
                   : (document.activeElement instanceof Element ? document.activeElement : null);
        const visible = (el) => {
          try { const cs = getComputedStyle(el); if (cs.visibility==='hidden'||cs.display==='none') return false; const r=el.getBoundingClientRect(); return r.width>0&&r.height>0; } catch(e) { return true; }
        };
        const eligible = (el) => {
          const tag=(el.tagName||'').toLowerCase();
          if (tag!=='input'&&tag!=='textarea'&&tag!=='select'&&!(el.isContentEditable)) return false;
          const type=(el.getAttribute('type')||'text').toLowerCase();
          if (['hidden','file','submit','button','reset','image'].includes(type)) return false;
          if (!includePw && type==='password') return false;
          if (tag==='select' && /top\.|go_to_related_page|expand_menu_tree/.test(String(el.getAttribute('onchange')||''))) return false;
          return true;
        };
        const pwd = document.querySelector('input[type="password"], input[id*="pass" i], input[name*="pass" i]');
        let baseForm = seed && seed.closest ? seed.closest('form') : null;
        if (!baseForm && pwd) baseForm = pwd.closest ? pwd.closest('form') : null;
        const scope = baseForm || (pwd && (pwd.closest && (pwd.closest('table,div,section') || pwd.parentElement))) || document;
        const pool = Array.from(scope.querySelectorAll('input, textarea, select, [contenteditable]')).filter(eligible).filter(visible);
        const items = [];
        const add = (el) => {
          if (!el) return;
          let selector = '';
          try {
            selector = (el.id ? '#' + CSS.escape(el.id) : '') || (el.name ? el.tagName.toLowerCase() + '[name="' + CSS.escape(el.name) + '"]' : '');
            if (!selector) {
              const idx = Array.from(el.parentNode ? el.parentNode.children : []).filter(x => x.tagName===el.tagName).indexOf(el) + 1;
              selector = el.tagName.toLowerCase() + ':nth-of-type(' + idx + ')';
            }
          } catch (e) {}
  let value='';
          if (el.type==='checkbox' || el.type==='radio') value = el.checked ? 'true' : 'false';
          else if (el.tagName==='SELECT' && el.multiple) value = Array.from(el.selectedOptions).map(o=>o.value).join('|;|');
          else if ('value' in el) value = el.value || '';
          else if (el.isContentEditable) value = el.textContent || '';
          items.push({ selector, value, framePath: __ff_getFramePath(window) });
        };
        if (pwd && pool.includes(pwd)) {
          const username = pool.find(el => {
            if (el===pwd) return false;
            const type=(el.getAttribute('type')||'text').toLowerCase();
            if (!['text','email','tel','number','search','url'].includes(type)) return false;
            const low=((el.name||'')+' '+(el.id||'')+' '+(el.placeholder||'')+' '+(el.title||'')).toLowerCase();
            return /user|login|email|mail|name/.test(low);
          }) || pool.find(el => el!==pwd && (el.getAttribute('type')||'text').toLowerCase()!=='password');
          if (username) add(username);
          add(pwd);
        } else {
          (pool.length>100?pool.slice(0,100):pool).forEach(add);
        }
        return { ok:true, rules: items };
      } catch(e) {
        return { ok:false, reason: String(e && e.message || e) };
      }
    };
  }
})();

// === FreeFiller: remember element under right-click to scope capture ===
(function(){
  try {
    window.__FF_LAST_RC_EL = null;
    window.addEventListener('contextmenu', function(e){ try { window.__FF_LAST_RC_EL = e.target || null; } catch(e){} }, true);
  } catch(e) { console.warn('[FreeFiller] RC tracker err', e); }
})();

// === FreeFiller: field serializer augmentation ===
function __ff_serializeField(el, val) {
  try {
    if (!el) return null;
    const tag = (el.tagName||'').toLowerCase();
    if (tag === 'iframe' || tag === 'frame') return null; // skip frames
    const rule = { selector: '', value: val , framePath: __ff_getFramePath(window) };
    // v1.4.55: keep stable framePath by default; legacy hint ignored
    return rule;
  } catch(e){ return null; }
}


// === FreeFiller: rule/frame filtering ===
function __ff_ruleMatchesFrame(rule) {
  if (!rule || !rule.framePath) return true; // empty means any frame
  try {
    return __ff_getFramePath(window) === rule.framePath;
  } catch (e) { 
    return true; 
  }
}

window.__FF_FRAME_URL_HINT__ = location.origin + location.pathname;
// === FreeFiller: Deep selector utilities (Shadow DOM) ===
function __ff_queryDeep(selector) {
  if (!selector) return null;
  if (selector.includes('>>>')) {
    const parts = selector.split('>>>').map(s => s.trim()).filter(Boolean);
    let root = document; let node = null;
    for (let i = 0; i < parts.length; i++) {
      const part = parts[i];
      try { node = root.querySelector(part); } catch (e) { return null; }
      if (!node) return null;
      if (i === parts.length - 1) return node;
      if (!node.shadowRoot) return null;
      root = node.shadowRoot;
    }
    return node || null;
  }
  return null;
}

// content script for FreeFiller (v1.3.1)
const AUTO_KEY = (origin) => `ff:auto:${origin}`;
// Use top page URL for rule matching when possible (helps when the login lives in an iframe).
const PAGE_HREF_FOR_RULES = (() => { try { return window.top.location.href; } catch(e) { return location.href; } })();



function globToRegExp(glob){
  return new RegExp('^' + glob
    .replace(/[.+^${}()|[\]\\]/g,'\\$&')
    .replace(/\*/g, '.*')
    .replace(/\?/g, '.') + '$');
}

function __ff_normalizeUrlForMatch(href, includeHash=true){
  try {
    const u = new URL(href, location.href);
    const base = `${u.protocol}//${u.host}${u.pathname}${u.search}`;
    return includeHash ? base + u.hash : base;
  } catch(e) { return String(href||''); }
}

function matchesGlob(url, glob) {
  try {
    const target = __ff_normalizeUrlForMatch(url, true);
    const targetNoHash = __ff_normalizeUrlForMatch(url, false);
    const re = globToRegExp(glob.endsWith('*') ? glob : glob + '*');
    return re.test(target) || re.test(targetNoHash);
  } catch (e) {
    return false;
  }
}

function ruleMatchesUrl(rule, href) {
  try {
    const glob = rule?.siteGlob || "*://*/*";
    return typeof matchesGlob === "function" ? matchesGlob(href, glob) : true;
  } catch(e) { return true; }
}


function dbg(enabled, ...args) { if (enabled) console.log('[FreeFiller]', ...args.map(__ff_safeLogArg)); }


function setValue(el, value, opts={}) {
  if (!el) return;
  try {
    const str = String(value ?? '').toLowerCase();
    if (el.type === 'checkbox' || el.type === 'radio') {
      const truthy = new Set(['true','1','yes','on','__checked__']);
      el.checked = truthy.has(str);
      if (opts.forceChange) el.dispatchEvent(new Event('change', { bubbles: true }));
      return;
    }
    return safeSetValue(el, value, opts);
  } catch (e) { console.error('setValue error', e); }
}


function labelTextFor(el) {
  const id = el.id;
  if (id) {
    const lab = document.querySelector(`label[for="${CSS.escape(id)}"]`);
    if (lab) return lab.textContent?.trim() || '';
  }
  const pl = el.closest('label');
  if (pl) return pl.textContent?.trim() || '';
  return '';
}

const __FF_LA_CACHE = new Map();
function findOneByLightningName(pattern, flags='i', debug=false) {
  try {
    const key = `${pattern}::${flags||'i'}`;
    let re = __FF_LA_CACHE.get(key);
    if (!re) { re = new RegExp(pattern, flags||'i'); __FF_LA_CACHE.set(key, re); }
    const candidates = Array.from(document.querySelectorAll('input, textarea, select'));
    for (const el of candidates) {
      const attrs = [el.name||'', el.id||'', el.placeholder||'', el.getAttribute('aria-label')||'', labelTextFor(el)];
      if (attrs.some(a => re.test(a))) {
        dbg(debug, "Matched via regex", `/${pattern}/${flags}`, "→", el);
        return el;
      }
    }
  } catch (e) { console.warn("Bad regex", pattern, e); }
  return null;
}


function __ff_fallbackFind(rule, debug=false){
  try{
    const sel = String(rule.selector||'');
    const tokens = Array.from(new Set(sel.toLowerCase().split(/[^a-z0-9]+/).filter(t=>t && t.length>=3)));
    const heur = [];
    if (tokens.some(t=>/pass|pwd/.test(t))) heur.push(/pass(word)?|pwd/i);
    if (tokens.some(t=>/user|login|email|mail/.test(t))) heur.push(/user(name)?|login|email|mail/i);
    if (!heur.length && tokens.length) heur.push(new RegExp(tokens[0].replace(/[^a-z0-9]/g,''), 'i'));
    const candidates = Array.from(document.querySelectorAll('input, textarea, select'));
    let best = null, bestScore = 0;
    for (const el of candidates){
      const attrs = [el.name||'', el.id||'', el.placeholder||'', el.getAttribute('aria-label')||'', labelTextFor(el)];
      let score = 0;
      for (const h of heur){ if (attrs.some(a => h.test(a))) score += 1; }
      if (score > bestScore){ best=el; bestScore=score; }
    }
    if (debug && best) dbg(debug, "Heuristic matched", {selector: sel, best});
    return bestScore>0 ? best : null;
  }catch(e){ return null; }
}

function findBySelectorOrRegex(rule, debug=false) {
  if (rule.selector && !rule.selector.startsWith('LA:')) {
    try { const el = (function(){try{return document.querySelector(rule.selector)}catch(e){return null}})() || __ff_queryDeep(rule.selector); if (el) dbg(debug, "Matched via selector", rule.selector, el); return el; } catch(e) { return null; }
  }
  if (rule.selector && rule.selector.startsWith('LA:')) {
    const raw = rule.selector.slice(3);
    const m = raw.match(/^\/(.*)\/([gimuy]*)$/);
    const pattern = m ? m[1] : raw;
    const flags = m ? (m[2] || 'i') : 'i';
    return findOneByLightningName(pattern, flags || 'i', debug);
  }
  return null;
}

async function applyFillWithState(state, {debug=false}={}) {
  /* FF_RECENT_HITS */ const recentRuleIds = new Set();
  const href = PAGE_HREF_FOR_RULES;
  const profiles = state.profiles || {};
  const activeProfile = (profiles[state.activeProfileId] && profiles[state.activeProfileId].data) || {};
  const rulesAll = (state.rules || []);
  const rules = rulesAll.filter(r => { const pidOk = !r.profileId || r.profileId === state.activeProfileId || !state.activeProfileId; const urlOk = !r.siteGlob || matchesGlob(href, r.siteGlob); return pidOk && urlOk; });
  if (debug) {
    console.groupCollapsed("[FreeFiller] Rule filter");
    for (const r of rulesAll.slice(0,20)) {
      const ok = (!r.profileId || r.profileId === state.activeProfileId) && (!r.siteGlob || matchesGlob(href, r.siteGlob));
      console.log(ok ? "✅" : "❌", r.siteGlob, "→", ok);
    }
    console.groupEnd();
  }
  let hits = 0;
  for (const rule of rules) {
    let el = (__ff_ruleMatchesFrame(rule) ? findBySelectorOrRegex(rule, debug) : null);
    if (!el && __ff_ruleMatchesFrame(rule)) el = __ff_fallbackFind(rule, debug);
    if (!el) continue;
    const v = (rule.value || '').replace(/\{\{\s*profile\.([\w-]+)\s*\}\}/g, (_, key) => activeProfile[key] ?? '');
    setValue(el, v);
    hits++;
    if (rule.id) recentRuleIds.add(rule.id);
  }
if (recentRuleIds.size) {
  const now = Date.now();
  const rec = {};
  for (const id of recentRuleIds) rec[id] = now;
  try {
    const cur = await chrome.storage.local.get({ recentRuleTimestamps: {} });
    await chrome.storage.local.set({ recentRuleTimestamps: { ...cur.recentRuleTimestamps, ...rec } });
  } catch (e) {}
}
if (debug) dbg(debug, `Filled ${hits} fields on`, href);
return hits;
}

// Snippets
function enableSnippets(snippets = []) {
  const map = new Map((snippets||[]).map(s => [s.trigger, s.value]));
  const handler = (e) => {
    const el = e.target;
    if (!(el instanceof HTMLInputElement || el instanceof HTMLTextAreaElement || el.isContentEditable)) return;
    const value = el.value ?? el.textContent ?? '';
    const m = value.match(/(^|\s)(;[a-zA-Z0-9_-]{2,})$/);
    if (!m) return;
    const trigger = m[2];
    if (!map.has(trigger)) return;
    const replacement = map.get(trigger);
    if (el.value !== undefined) {
      el.value = value.replace(trigger, replacement);
      el.dispatchEvent(new Event('input', { bubbles: true }));
    } else {
      el.textContent = value.replace(trigger, replacement);
      el.dispatchEvent(new Event('input', { bubbles: true }));
    }
  };
  document.addEventListener('keyup', handler);
}

// Auto-save
function enableAutoSave(enabled = true) {
  if (!enabled) return;
  const originKey = AUTO_KEY(location.origin);
  const save = () => {
    const inputs = Array.from(document.querySelectorAll('input, textarea, select'));
    const payload = inputs.map(el => {
      const sel = el.id ? `#${CSS.escape(el.id)}` : (el.name ? `[name="${el.name}" i]` : null);
      return sel ? { sel, type: el.type, val: (el.type==='checkbox'||el.type==='radio') ? el.checked : el.value } : null;
    }).filter(Boolean);
    try { localStorage.setItem(originKey, JSON.stringify(payload)); } catch(e) {}
  };
  document.addEventListener('change', save, true);
  document.addEventListener('input', save, true);
}

/* FF_ROBUST_AUTOFILL */
async function robustAutoFill() {
  const s = await chrome.storage.local.get();
  if (!s?.settings?.autoFillOnLoad) return;
  const debug = !!s?.settings?.debug;
  let attempts = 0, maxAttempts = 3;
  let filled = 0;

  async function tryFill() {
    attempts++;
    try {
      const hits = await applyFillWithState(s, { debug });
      filled = Math.max(filled, hits||0);
      if (debug) console.debug("[FreeFiller] robustAutoFill attempt", attempts, "hits:", hits);
      if (filled > 0 || attempts >= maxAttempts) return;
      setTimeout(tryFill, attempts === 1 ? 400 : 900);
    } catch (e) {
      if (debug) console.warn("[FreeFiller] robustAutoFill error:", e);
    }
  }

  // Observed selectors common to device GUIs like Ubiquiti
  const targets = ["#loginform-username", "#loginform-password", "input#username", "input#password"];
  let observedTriggered = false;
  const obs = new MutationObserver(() => {
    if (observedTriggered) return;
    for (const sel of targets) {
      const el = document.querySelector(sel);
      if (el) {
        observedTriggered = true;
        tryFill();
        break;
      }
    }
  });
  try {
    obs.observe(document.documentElement || document.body, { childList: true, subtree: true });
    setTimeout(() => { try { obs.disconnect(); } catch(e){} }, 3500);
  } catch(e) {}

  // Kick off first attempt a tick after idle
  setTimeout(tryFill, 150);
}

async function runAutoFillIfEnabled() {
  await robustAutoFill();
  const s = await chrome.storage.local.get();
  enableSnippets(s.snippets);
  enableAutoSave(s.settings?.autoSave);
}

chrome.runtime.onMessage.addListener((msg) => {
  if (msg?.type === 'FREEFILLER_FILL') {
    applyFillWithState(msg.state, { debug: !!msg.state?.settings?.debug }).then(() => {
      enableSnippets(msg.state.snippets);
      enableAutoSave(msg.state.settings?.autoSave);
    });
  }
});

runAutoFillIfEnabled();

// ===== FreeFiller v1.4.27 content wrapper: unified matcher & quiet logs =====
(() => {
  const _origApply = (typeof applyFillWithState === "function") ? applyFillWithState : null;
  if (_origApply && typeof matchesGlob === "function") {
    window.applyFillWithState = async function patchedApply(state, opts={}) {
      const href = PAGE_HREF_FOR_RULES;
      const debug = !!opts.debug || !!state?.settings?.debug;
      const rules = Array.isArray(state?.rules) ? state.rules.filter(r => ruleMatchesUrl(r, href)) : [];
      if (debug) console.debug("[FreeFiller v1.4.27] rules to apply:", rules.length);
      return _origApply.call(this, { ...state, rules }, opts);
    };
  }
})();
// ===== end v1.4.27 content wrapper =====



// === FreeFiller: safe wrapper around findBySelectorOrRegex ===
(function wrapFFFindOnce(){
  try {
    const orig = window.findBySelectorOrRegex;
    if (typeof orig === 'function' && !orig.__ffWrapped) {
      function wrapped(rule, debug=false) {
        try { if (typeof __ff_ruleMatchesFrame === 'function' && !__ff_ruleMatchesFrame(rule)) return null; } catch(e){ }
        return orig(rule, debug);
      }
      wrapped.__ffWrapped = true;
      window.findBySelectorOrRegex = wrapped;
    }
  } catch(e) { console.error('[FreeFiller] wrap error', e); }
})();

// === Page-side fillNow for context-menu ===
(function(){
  if (!window.FreeFiller) window.FreeFiller = {};
  if (!FreeFiller.fillNow) {
    FreeFiller.fillNow = async () => {
      // === De-dupe: values already set? ===
      try {
        const last = FF_LAST || {};
        if (Array.isArray(last.targets) && last.targets.length) {
          let allMatch = true;
          for (const it of last.targets) {
            try {
              const el = document.querySelector(it.selector);
              if (!el) { allMatch = false; break; }
              const isBool = el.type === 'checkbox' || el.type === 'radio';
              const isPwd = el.type === 'password';
              let cur = null;
              if (isBool) cur = el.checked ? 'true' : 'false';
              else if (isPwd) cur = 'len:' + String(el.value ?? '').length;
              else cur = String((el.value ?? el.textContent ?? '')).trim();
              const prev = String(it.value ?? '').trim();
              if (cur !== prev) { allMatch = false; break; }
            } catch(_) { allMatch = false; break; }
          }
          if (allMatch) {
            if (window.__FF_DEBUG) console.log("[FreeFiller] De-dupe: skip (values already set)");
            return { ok: true, deduped: "values" };
          }
        }
      } catch(_) {}

      // === De-dupe quick repeats (start-based) ===
      try {
        const now = Date.now();
        const href = (location && location.href) ? location.href : "";
        const windowMs = 2500;
        if (href === FF_LAST_START.href && (now - FF_LAST_START.t) < windowMs) {
          if (window.__FF_DEBUG) console.log("[FreeFiller] De-dupe: skip (time window)");
          return { ok: true, deduped: true };
        }
        FF_LAST_START.t = now;
        FF_LAST_START.href = href;
      } catch(_) {}

      try {
        const state = await chrome.storage.local.get();
        const debug = !!state.settings?.debug; try{ window.__FF_DEBUG = debug; }catch(_){}
        try {
          FF_IS_FILLING = true; FF_LAST_TARGETS = [];
          await applyFillWithState(state, { debug });
          try {
            FF_LAST.t = Date.now();
            FF_LAST.href = (location && location.href) ? location.href : "";
            if (Array.isArray(FF_LAST_TARGETS) && FF_LAST_TARGETS.length) FF_LAST.targets = FF_LAST_TARGETS;
          } catch(_) {}
        } finally {
          try { FF_IS_FILLING = false; } catch(_) {}
        }
        return { ok: true };
      } catch (e) {
        if (window.__FF_DEBUG) console.warn("[FreeFiller] fillNow error", e);
        return { ok: false, reason: String(e && e.message || e) };
      }
    };
  }
})();
// === Message hook for keyboard Fill Now ===
try {
  chrome.runtime.onMessage.addListener((msg, sender, sendResponse) => {
    if (msg && msg.type === "FF_FILL_NOW") { if (window.__FF_DEBUG) console.log("[FreeFiller] Hotkey received (FF_FILL_NOW)");
      try { if (window.FreeFiller && typeof FreeFiller.fillNow === "function") FreeFiller.fillNow(); } catch (e) {}
      try { sendResponse({ ok: true }); } catch (e) {}
      return true;
    }
  });
} catch (e) {}
