// === Place Tip/Editing banner inside the original header (idempotent) ===
(function(){
  try {
    // Remove any legacy injected top bar if it exists
    const old = document.getElementById('ffTopBar');
    if (old && old.parentNode) old.parentNode.removeChild(old);
  } catch(_) {}

  try {
    const header = document.querySelector('header');
    if (!header) return;
    // Find/create the status node
    let status = document.getElementById('editStatus');
    if (!status) {
      status = document.createElement('div');
      status.id = 'editStatus';
    }
    status.classList.add('status'); // keeps compatibility with previous logic

    // Use CSS classes expected by options.css for green labels
    status.innerHTML = ''
      + '<span class="msg msg-idle">'
      +   '<span class="status-label">Tip:</span> '
      +   '"Rules" changes will save when you click outside the field you are editing. '
      +   'Updated rules will move to the top if you have "Float recently matched" checked.'
      + '</span>'
      + '<span class="msg msg-active">'
      +   '<span class="status-label">Editing…</span> '
      +   '<i>PAUSING</i> all list order movement. Click outside the field you are editing to finish and save. '
      +   'After saving, updated rule will move to the top if you have "Float recently matched" checked.'
      + '</span>';

    // Insert directly under the title row
    const titleRow = header.querySelector('.title') || header.firstElementChild;
    if (titleRow && titleRow.nextSibling) {
      header.insertBefore(status, titleRow.nextSibling);
    } else {
      header.appendChild(status);
    }
  } catch(_) {}
})(); 

// === Editing guard: pause auto-refresh & badge aging while user is typing (idempotent) ===
(() => {
  if (window.FF_EDIT && window.FF_EDIT.__installed) return;

  window.FF_EDIT = window.FF_EDIT || {
    active: false,
    locks: 0,
    pending: false,
    blurTimer: null,
    lastInput: 0,
    __listeners: false,
    __installed: true
  };

  window.ffIsEditing = window.ffIsEditing || function () {
    try {
      if (window.FF_EDIT.locks > 0) return true;
      const ae = document.activeElement;
      if (ae && ae.matches && ae.matches('input, textarea, select, [contenteditable], [contenteditable=""], [contenteditable="true"]')) return true;
    } catch (_) {}
    return !!window.FF_EDIT.active;
  };

  window.ffLock = window.ffLock || function () {
    window.FF_EDIT.locks++;
    window.FF_EDIT.active = true;
  };

  window.ffUnlock = window.ffUnlock || function () {
    window.FF_EDIT.locks = Math.max(0, window.FF_EDIT.locks - 1);
    if (window.FF_EDIT.locks === 0) {
      window.FF_EDIT.active = false;
      try { const b = document.getElementById('editStatus'); if (b) b.classList.remove('active'); } catch(_) {}if (window.FF_EDIT.pending) {
        window.FF_EDIT.pending = false;
        try {
          const p = renderAll();
          if (p && typeof p.then === 'function') p.catch(() => {});
        } catch (_) {}
      }
    }
  };

  if (!window.FF_EDIT.__listeners) {
    try {
      document.addEventListener('focusin', (e) => {
        if (e?.target?.matches?.('input, textarea, select, [contenteditable], [contenteditable=""], [contenteditable="true"]')) {
          window.FF_EDIT.active = true;
        }
      });
      document.addEventListener('input', (e) => {
        if (e?.target?.matches?.('input, textarea, select, [contenteditable], [contenteditable=""], [contenteditable="true"]')) {
          window.FF_EDIT.active = true;
          window.FF_EDIT.lastInput = Date.now();
        }
      });
      document.addEventListener('focusout', () => {
        try { clearTimeout(window.FF_EDIT.blurTimer); } catch(_) {}
        window.FF_EDIT.blurTimer = setTimeout(() => {
          try {
            const ae = document.activeElement;
            const still = !!(ae?.matches?.('input, textarea, select, [contenteditable], [contenteditable=""], [contenteditable="true"]'));
            window.FF_EDIT.active = still || (window.FF_EDIT.locks > 0);
            if (!window.FF_EDIT.active && window.FF_EDIT.pending) {
              window.FF_EDIT.pending = false;
              try { const b = document.getElementById('editStatus'); if (b) b.classList.remove('active'); } catch(_) {}try {
                const p = renderAll();
                if (p && typeof p.then === 'function') p.catch(() => {});
              } catch(_) {}
            }
          } catch(_) {}
        }, 200);
      });
    } catch(_) {}
    window.FF_EDIT.__listeners = true;
  }
})();

// FreeFiller Options (v1.4.7) — stable
let RECENT_BADGE_MAX_AGE_MS = 7*24*60*60*1000;
function fmtAge(ms){const s=Math.floor(ms/1000),m=Math.floor(s/60),h=Math.floor(m/60),d=Math.floor(h/24);if(d>0)return d+"d";if(h>0)return h+"h";if(m>0)return m+"m";return Math.max(1,s)+"s";}

function uid() { return crypto.randomUUID(); }
function filenameWithTimestamp(base, ext){
  const d = new Date();
  const pad = (n) => String(n).padStart(2,'0');
  const ts = `${d.getFullYear()}-${pad(d.getMonth()+1)}-${pad(d.getDate())}`+
            `_${pad(d.getHours())}-${pad(d.getMinutes())}-${pad(d.getSeconds())}`;
  return `${base}_${ts}${ext}`;
}


/* FF_DEBOUNCED_SET */
const ffDebouncers = new Map();
async function ffDebouncedSet(key, payload, wait=400){
  const k = key+":"+Object.keys(payload).sort().join(',');
  clearTimeout(ffDebouncers.get(k));
  ffDebouncers.set(k, setTimeout(async ()=>{ try{ await set(payload); }catch(e){} }, wait));
}

async function state() {
  const d = await chrome.storage.local.get();
  if (!d.profiles) d.profiles = { personal: { id:"personal", name:"Personal", data:{} } };
  if (!d.activeProfileId) d.activeProfileId = "personal";
  if (!d.rules) d.rules = [];
  if (!d.snippets) d.snippets = [];
  if (!d.settings) d.settings = { autoSave: true, autoFillOnLoad: true, debug: false, sortRules: true, groupBySite: true, secondarySort: "selector", floatRecent: true };
  if (!d.recentRuleTimestamps) d.recentRuleTimestamps = {};
  if (!d.settings) d.settings = {};
  if (!d.settings.theme) d.settings.theme = 'dark';
  if (!d.settings) d.settings = {};
  if (!d.settings.recentWindowDays) d.settings.recentWindowDays = 7;
  // Assign stable IDs to rules that lack one
  let mutated = false;
  for (const r of d.rules) {
    if (!r.id) { r.id = (crypto?.randomUUID?.() || (Math.random().toString(36).slice(2)+"-"+Date.now())); mutated = true; }
  }
  if (mutated) { await chrome.storage.local.set({ rules: d.rules }); }
  return d;
}

function set(patch){ return chrome.storage.local.set(patch); }

// === Duplicate helpers ===
function upsertRulesLocal(rules, newOnes) {
  const idx = new Map();
  rules.forEach((r,i)=> idx.set(`${r.siteGlob}||${r.selector}||${r.profileId||""}`, i));
  for (const n of newOnes) {
    const key = `${n.siteGlob}||${n.selector}||${n.profileId||""}`;
    if (idx.has(key)) {
      const i = idx.get(key);
      rules[i] = { ...rules[i], ...n, id: rules[i].id || n.id };
    } else {
      rules.push(n);
      idx.set(key, rules.length-1);
    }
  }
  return rules;
}
function dedupeRulesLocal(rules) {
  const out = []; const seen = new Set();
  for (const r of rules) {
    const key = `${r.siteGlob}||${r.selector}||${r.profileId||""}`;
    if (seen.has(key)) continue;
    seen.add(key); out.push(r);
  }
  return out;
}
function countDuplicates(rules) {
  const seen = new Set(); let dups = 0;
  for (const r of (rules||[])) {
    const key = `${r.siteGlob}||${r.selector}||${r.profileId||""}`;
    if (seen.has(key)) dups++; else seen.add(key);
  }
  return dups;
}
async function updateDedupeUI() {
  try {
    const d = await state();
    const n = countDuplicates(d.rules||[]);
    
const el = document.getElementById("dupCount");
const btn = document.getElementById("dedupeRulesBtn");
const el2 = document.getElementById("dupCount2");
const btn2 = document.getElementById("dedupeRulesBtn2");
const msg = n > 0 ? `Duplicates detected: ${n}` : `No duplicates`;
if (el) el.textContent = msg;
if (el2) el2.textContent = msg;
if (btn) {
  btn.disabled = n === 0;
  btn.style.opacity = n === 0 ? ".5" : "1";
  btn.title = n === 0 ? "No duplicates to remove" : "Remove duplicate rules";
}
if (btn2) {
  btn2.disabled = n === 0;
  btn2.style.opacity = n === 0 ? ".5" : "1";
  btn2.title = n === 0 ? "No duplicates to remove" : "Remove duplicate rules";
}
  } catch (e) { console.error("[FreeFiller] updateDedupeUI failed", e); }
}

// === Profiles ===
async function renderProfiles(d) {
  const wrap = document.getElementById("profiles"); if (!wrap) return; wrap.innerHTML = "";
  for (const p of Object.values(d.profiles)) {
    const div = document.createElement("div");
    const radio = document.createElement("input"); radio.type = "radio"; radio.name = "activeProfile"; radio.value = p.id;
    radio.checked = (p.id === d.activeProfileId);
    radio.onchange = async () => set({ activeProfileId: p.id });
    const name = document.createElement("input"); name.value = p.name;
    name.oninput = async (e) => { p.name = e.target.value; await set({ profiles: d.profiles }); };
    const del = document.createElement("button"); del.textContent = "Delete";
    del.onclick = async () => {
      if (Object.keys(d.profiles).length === 1) return alert("Need at least one profile.");
      delete d.profiles[p.id];
      if (d.activeProfileId === p.id) d.activeProfileId = Object.keys(d.profiles)[0];
      await set({ profiles: d.profiles, activeProfileId: d.activeProfileId });
      renderAll();
    };
    div.append(radio, name, del); wrap.appendChild(div);
  }
}

// === Rule rows ===
function renderRuleRow(d, r) {
  // helper
  function input(obj, key) {
    const td = document.createElement("td");
    const el = document.createElement("input");
    el.value = obj[key] || "";
    el.style.width = "100%";
    el.onfocus = () => { try { ffLock(obj.id); } catch(_){} 
      /* FF_EDIT_HINT_ONCE */ 
      try { if (!window.__ffEditHintShown) { 
        const b = document.getElementById('editStatus'); if (b) { b.classList.add('active'); }
        window.__ffEditHintShown = true; 
        setTimeout(() => { try{ if (!FF_EDIT.active) { const b=document.getElementById('editStatus'); if (b) b.classList.remove('active'); } }catch(_){ } }, 2800);
      } } catch(_){}
    };
    el.onblur  = () => { try { ffUnlock(); } catch(_){} };
    el.oninput = async (e) => {
      const cur = await state();
      const idx = (cur.rules || []).findIndex(rr => rr.id === obj.id);
      if (idx !== -1) {
        cur.rules[idx][key] = e.target.value;
        // Debounced save to avoid thrashing storage
        ffDebouncedSet("rules", { rules: cur.rules }, 350);
        /* FF_UPDATE_RECENT_ON_EDIT */
        try {
          const now = Date.now();
          const cur2 = await chrome.storage.local.get({ recentRuleTimestamps: {} });
          const rec2 = { ...cur2.recentRuleTimestamps };
          if (obj.id) rec2[obj.id] = now;
          await chrome.storage.local.set({ recentRuleTimestamps: rec2 });
        } catch(e) {}
      }
    };
    if (key === "value") {
      const wrap = document.createElement("div");
      wrap.style.display = "flex";
      wrap.style.gap = "6px";
      wrap.style.alignItems = "center";
      el.style.flex = "1";
      wrap.appendChild(el);
      const btn = document.createElement("button");
      btn.type = "button";
      btn.textContent = "Copy";
      btn.title = "Copy value to clipboard";
      btn.addEventListener("click", async () => {
        try { await navigator.clipboard.writeText(el.value || ""); btn.textContent = "Copied"; setTimeout(()=>btn.textContent="Copy", 700);} catch{}
      });
      td.appendChild(wrap);
      wrap.appendChild(btn);
    } else {
      td.appendChild(el);
    }
    return td;
  }

  const tr = document.createElement("tr");
  const site = input(r, "siteGlob");
  const sel  = input(r, "selector");
  const val  = input(r, "value");

  // profile select
  const prof = document.createElement("td");
  const s = document.createElement("select");
  for (const p of Object.values(d.profiles)) {
    const o = document.createElement("option");
    o.value = p.id; o.textContent = p.name;
    if (r.profileId === p.id) o.selected = true;
    s.appendChild(o);
  }
  s.onchange = async (e) => {
    const cur = await state();
    const idx = (cur.rules || []).findIndex(rr => rr.id === r.id);
    if (idx !== -1) {
      cur.rules[idx].profileId = e.target.value;
      await set({ rules: cur.rules });
      await renderAll();
    }
  };
  prof.appendChild(s);

  // delete button
  const del = document.createElement("td");
  const b = document.createElement("button");
  b.textContent = "✕"; b.title = "Delete rule";
  b.onclick = async () => {
    const cur = await state();
    const idx = (cur.rules || []).findIndex(rr => rr.id === r.id);
    if (idx !== -1) {
      cur.rules.splice(idx, 1);
      await set({ rules: cur.rules });
      await renderAll();
    }
  };
  del.appendChild(b);

  // append cells
  tr.append(site, sel, val, prof, del);

  // recent badge (expiry-aware)
  const ts = d.recentRuleTimestamps ? d.recentRuleTimestamps[r.id] : 0;
  if (r.id && ts && (Date.now() - ts) <= RECENT_BADGE_MAX_AGE_MS) {
    const badge = document.createElement("span");
    const age = fmtAge(Date.now() - ts);
    badge.textContent = `recent (${age})`;
    badge.className = "recent-badge";
    badge.setAttribute("data-ff-ts", String(ts));
    
    badge.title = "Added or edited recently";
    sel.appendChild(badge);
  } else if (r.id && ts) {
    delete d.recentRuleTimestamps[r.id];
    set({ recentRuleTimestamps: d.recentRuleTimestamps });
  }

  return tr;
}

// === Rules table / grouping ===
const CHUNK_SIZE = 250;
function renderRules(d) {
  const groupsWrap = document.getElementById("rulesGroups");
  const rulesTable = document.getElementById("rulesTable");
  const tb = rulesTable ? rulesTable.querySelector("tbody") : null;
  if (groupsWrap) groupsWrap.innerHTML = "";
  if (tb) tb.innerHTML = "";
  applyHeaderSortListeners && applyHeaderSortListeners();
  const filter = (document.getElementById("ruleFilter")?.value || "").toLowerCase();
  const sortEnabled = !!d.settings?.sortRules;
  const groupEnabled = !!d.settings?.groupBySite;
  const sec = (d.settings?.secondarySort || "selector");
  const floatRecent = FF_EDIT.active ? false : !!d.settings?.floatRecent;
  RECENT_BADGE_MAX_AGE_MS=(Number(d.settings?.recentWindowDays)||7)*24*60*60*1000;

  const recent = d.recentRuleTimestamps || {};
  const decorated = d.rules.map(r => ({...r, __recentAt: recent[r.id] || 0}));

  const secKey = (r) => {
    if (sec === "profile") return (r.profileId || "").toLowerCase();
    if (sec === "value") return (r.value || "").toLowerCase();
    return (r.selector || "").toLowerCase();
  };
  const cmp = (a,b) => {
    const ag=(a.siteGlob||"").toLowerCase(), bg=(b.siteGlob||"").toLowerCase();
    if (ag < bg) return -1; if (ag > bg) return 1;
    const as=secKey(a), bs=secKey(b);
    if (as < bs) return -1; if (as > bs) return 1;
    return 0;
  };

  let list = decorated.filter(r => {
    if (!filter) return true;
    const hay = [r.siteGlob, r.selector, r.value, r.profileId].map(x => (x||"").toLowerCase()).join(" ");
    return hay.includes(filter);
  });

  if (floatRecent) list.sort((a,b) => (b.__recentAt||0) - (a.__recentAt||0));
  if (sortEnabled) list = list.sort(cmp);

  
if (!groupEnabled) {
  if (rulesTable) rulesTable.style.display = "";
  if (tb) {
    let i = 0;
    (function appendChunk(){
      const frag = document.createDocumentFragment();
      for (let c = 0; c < CHUNK_SIZE && i < list.length; c++, i++) {
        frag.appendChild(renderRuleRow(d, list[i]));
      }
      tb.appendChild(frag);
      if (i < list.length) requestAnimationFrame(appendChunk);
    })();
  }
  return;
}


  if (rulesTable) rulesTable.style.display = "none";
  const bySite = {};
  for (const r of list) {
    const key = r.siteGlob || "(no site)";
    (bySite[key] ||= []).push(r);
  }
  const siteKeys = Object.keys(bySite).sort();
  for (const site of siteKeys) {
    const det = document.createElement("details");
    det.open = true;
    const sum = document.createElement("summary");
    sum.textContent = `${site}  (${bySite[site].length})`;
    groupsWrap.appendChild(det);
    det.appendChild(sum);

    const table = document.createElement("table");
    table.style.width = "100%";
    table.style.borderCollapse = "collapse";
    const thead = document.createElement("thead");
    thead.innerHTML = "<tr><th>Site glob</th><th>Selector</th><th>Value</th><th>Profile</th><th></th></tr>";
    const tbody = document.createElement("tbody");
    det.appendChild(table);
    table.appendChild(thead);
    table.appendChild(tbody);

    
let gi = 0; const arr = bySite[site];
(function appendGroupChunk(){
  const frag = document.createDocumentFragment();
  for (let c = 0; c < CHUNK_SIZE && gi < arr.length; c++, gi++) {
    frag.appendChild(renderRuleRow(d, arr[gi]));
  }
  tbody.appendChild(frag);
  if (gi < arr.length) requestAnimationFrame(appendGroupChunk);
})();

  }
}

// === Snippets ===
async function renderSnippets(d) {
  const tb = document.querySelector("#snipTable tbody"); if (!tb) return; tb.innerHTML = "";
  for (const s of d.snippets) {
    const tr = document.createElement("tr");
    tr.append(cell("trigger", s), cell("value", s), delCell());
    tb.appendChild(tr);
    function cell(k, obj){
      const td = document.createElement("td"); const i = document.createElement("input"); i.value = obj[k] || ""; i.style.width = "100%";
      i.oninput = async (e)=>{ obj[k]=e.target.value; await set({ snippets: d.snippets }); };
      td.appendChild(i); return td;
    }
    function delCell(){
      const td = document.createElement("td"); const b = document.createElement("button"); b.textContent="✕";
      b.onclick = async ()=>{ d.snippets = d.snippets.filter(x=>x!==s); await set({ snippets: d.snippets }); renderAll(); };
      td.appendChild(b); return td;
    }
  }
}

// === Render all ===
async function renderAll() {
  const d = await state();
  renderProfiles(d); renderRules(d); renderSnippets(d);
  const active = d.profiles[d.activeProfileId];
  const profileData = document.getElementById("profileData");
  if (profileData) profileData.value = JSON.stringify(active?.data || {}, null, 2);
  const setAutoFill = document.getElementById("setAutoFill");
  if (setAutoFill) setAutoFill.checked = !!d.settings?.autoFillOnLoad;
  const setDebug = document.getElementById("setDebug");
  if (setDebug) setDebug.checked = !!d.settings?.debug;
  const sortBox = document.getElementById("sortRules");
  if (sortBox) sortBox.checked = !!d.settings?.sortRules;
  const groupBox = document.getElementById("groupBySite");
  if (groupBox) groupBox.checked = !!d.settings?.groupBySite;
  const secSel = document.getElementById("secondarySort");
  if (secSel) secSel.value = d.settings?.secondarySort || "selector";
  const floatBox = document.getElementById("floatRecent");
  if (floatBox) floatBox.checked = !!d.settings?.floatRecent;
  await updateDedupeUI();
}

// === Buttons / Events ===
document.getElementById("addProfile")?.addEventListener("click", async () => {
  const d = await state(); const id = uid(); d.profiles[id] = { id, name: "New Profile", data: {} };
  await set({ profiles: d.profiles, activeProfileId: id }); renderAll();
});
document.getElementById("saveProfileData")?.addEventListener("click", async () => {
  try {
    const d = await state(); const json = JSON.parse(document.getElementById("profileData").value || "{}"); d.profiles[d.activeProfileId].data = json;
    await set({ profiles: d.profiles }); alert("Saved.");
  } catch(e) { alert("Invalid JSON."); }
});
document.getElementById("addRule")?.addEventListener("click", async () => {
  const d = await state(); d.rules.push({ id: uid(), siteGlob: "*://*/*", selector: "", value: "", profileId: d.activeProfileId });
  await set({ rules: d.rules }); await renderAll();
});
document.getElementById("addSnip")?.addEventListener("click", async () => {
  const d = await state(); d.snippets.push({ trigger: ";example", value: "Hello world" }); await set({ snippets: d.snippets }); renderAll();
});

// CSV export
document.getElementById("exportCSV")?.addEventListener("click", async () => {
  const d = await state();
  const rows = [["siteGlob","selector","value","profileId"], ...d.rules.map(r=>[r.siteGlob,r.selector,r.value,r.profileId||""])];
  const csv = rows.map(r => r.map(x => `"${String(x||"").replaceAll('"','""')}"`).join(",")).join("\n");
  const blob = new Blob([csv], { type: "text/csv" }); const url = URL.createObjectURL(blob);
  chrome.downloads?.download({ url, filename: filenameWithTimestamp("FreeFiller-Rules", ".csv"), saveAs: true });
});

// CSV import
document.getElementById("importCSV")?.addEventListener("change", async (e) => {
  const f = e.target.files?.[0]; if (!f) return; const text = await f.text();
  const lines = text.split(/\r?\n/).filter(Boolean); const [, ...rows] = lines; const d = await state();
  const batch = [];
  for (const line of rows) {
    const cols = line.match(/("([^"]|"")*"|[^,]+)/g)?.map(c => c.replace(/^"|"$/g, "").replaceAll('""','"')) || [];
    const [siteGlob, selector, value, profileId] = cols;
    batch.push({ id: uid(), siteGlob, selector, value, profileId: profileId || d.activeProfileId });
  }
  d.rules = upsertRulesLocal(d.rules, batch);
  await set({ rules: d.rules }); await renderAll();
});

// Lightning CSV import
document.getElementById("importLightning")?.addEventListener("change", async (e) => {
  try {
    const f = e.target.files?.[0]; if (!f) return;
    let text = await f.text();
    if (text.charCodeAt(0) === 0xFEFF) text = text.slice(1);
    text = text.replace(/\r\n/g, "\n").replace(/\r/g, "\n");
    const d = await state();

    const lines = text.split("\n");
    let i = 0, phase = null;
    const batch = [];
    let rulesCount = 0, profileCount = 0;

    const parseCSVLine = (line) => {
      const out = []; let cur = ""; let inQ = false;
      for (let idx = 0; idx < line.length; idx++) {
        const ch = line[idx];
        if (ch === '"') {
          if (inQ && line[idx+1] === '"') { cur += '"'; idx++; }
          else { inQ = !inQ; }
        } else if (ch === ',' && !inQ) {
          out.push(cur); cur = "";
        } else {
          cur += ch;
        }
      }
      out.push(cur);
      return out.map(s => s.trim());
    };

    while (i < lines.length) {
      let raw = lines[i].trim();
      if (!raw) { i++; continue; }

      const norm = raw.replace(/,+$/,"").toUpperCase();
      if (norm.startsWith("### AUTOFILL PROFILES")) { phase = "profiles"; i++; }
      else if (norm.startsWith("### AUTOFILL RULES")) { phase = "rules"; i++; }
      else {
        const upper = raw.toUpperCase();
        if (upper.startsWith("PROFILE ID,") || upper.startsWith("RULE ID,")) { i++; continue; }

        const cols = parseCSVLine(raw).map(s => s.replace(/^"|"$/g, "").replace(/""/g, '"'));
        if (phase === "profiles") {
          const pid = cols[0] || ""; const name = cols[1] || pid;
          if (pid) {
            if (!d.profiles[pid]) d.profiles[pid] = { id: pid, name: name || pid, data: {} };
            profileCount++;
          }
        } else if (phase === "rules") {
          const rid  = cols[0] || uid();
          const name = cols[2] || "";
          const value= cols[3] || "";
          let site   = cols[4] || "";
          const pid  = cols[6] || d.activeProfileId;
          if (!name || !site) { i++; continue; }

          let selector;
          const m = name.match(/^\/(.*)\/([gimuy]*)$/);
          if (m) {
            const pattern = m[1]; const flags = m[2] || 'i';
            selector = `LA:/${pattern}/${flags}`;
          } else {
            selector = `[name="${name}" i]`;
          }

          if (!/^\w+:\/\//.test(site)) site = `*://${site}`;
          if (!site.endsWith("*")) site = site + "*";

          batch.push({ id: rid, siteGlob: site, selector, value, profileId: pid });
          rulesCount++;
        }
      }
      i++;
    }

    d.rules = upsertRulesLocal(d.rules, batch);
    await set({ profiles: d.profiles, rules: d.rules });
    console.log("[FreeFiller] Lightning import:", { profilesAdded: profileCount, rulesParsed: rulesCount, batchSize: batch.length });
    await renderAll();
  } catch (err) {
    console.error("[FreeFiller] Lightning CSV import failed:", err);
    alert("Lightning CSV import failed. Check console for details.");
  }
});

// JSON import/export
document.getElementById("exportJSON")?.addEventListener("click", async () => {
  const d = await state(); const blob = new Blob([JSON.stringify(d, null, 2)], { type: "application/json" }); const url = URL.createObjectURL(blob);
  chrome.downloads?.download?.({ url, filename: filenameWithTimestamp("FreeFiller-Backup", ".json"), saveAs: true });
});
document.getElementById("importJSON")?.addEventListener("change", async (e) => {
  const f = e.target.files?.[0]; if (!f) return; const text = await f.text(); const json = JSON.parse(text);
  if (Array.isArray(json.rules)) json.rules = dedupeRulesLocal(json.rules);
  await chrome.storage.local.set(json); alert("Imported (deduped)."); renderAll();
});

// Toolbar events
document.getElementById("sortRules")?.addEventListener("change", async (e) => {
  const d = await state(); d.settings.sortRules = e.target.checked; await set({ settings: d.settings }); renderRules(d);
});
document.getElementById("groupBySite")?.addEventListener("change", async (e) => {
  const d = await state(); d.settings.groupBySite = e.target.checked; await set({ settings: d.settings }); renderRules(d);
});
document.getElementById("secondarySort")?.addEventListener("change", async (e) => {
  const d = await state(); d.settings.secondarySort = e.target.value; await set({ settings: d.settings }); renderRules(d);
});
document.getElementById("floatRecent")?.addEventListener("change", async (e) => {
  const d = await state(); d.settings.floatRecent = e.target.checked; await set({ settings: d.settings }); renderRules(d);
});
document.getElementById("dedupeRulesBtn")?.addEventListener("click", async () => {
  const d = await state();
  const before = d.rules.length;
  d.rules = dedupeRulesLocal(d.rules);
  const after = d.rules.length;
  await set({ rules: d.rules });
  alert(`Deduplicated rules: removed ${before - after} duplicate(s).`);
  await renderAll();
});

// Settings toggles
document.getElementById("setAutoFill")?.addEventListener("change", async (e) => {
  const d = await state(); d.settings.autoFillOnLoad = e.target.checked; await set({ settings: d.settings });
});
document.getElementById("setDebug")?.addEventListener("change", async (e) => {
  const d = await state(); d.settings.debug = e.target.checked; await set({ settings: d.settings });
});

// Safe init
(async () => {
  try { await renderAll(); }
  catch (e) { console.error("[FreeFiller] Options init failed:", e); }
})();


(() => { const el=document.getElementById("ruleFilter"); if(!el) return; let t; el.addEventListener("input", () => { clearTimeout(t); t=setTimeout(async()=>{const d=await state(); renderRules(d);},150); }); })();


document.getElementById("includePwEntire")?.addEventListener("change", async (e) => {
  const d = await chrome.storage.local.get({ settings: {} });
  d.settings = d.settings || {};
  d.settings.includePwEntire = !!e.target.checked;
  await chrome.storage.local.set({ settings: d.settings });
});


// sync includePwEntire on load (canonical)
(async () => {
  try {
    const d = await chrome.storage.local.get({ settings: {} });
    const el = document.getElementById("includePwEntire");
    if (el) el.checked = !!d.settings?.includePwEntire;
  } catch(_) {}
})();

async function applyHeaderSortListeners() {
  const table = document.getElementById("rulesTable");
  if (!table) return;
  const ths = table.querySelectorAll("thead th");
  const cols = ["siteGlob","selector","value","profile"];
  ths.forEach((th, i) => {
    const key = cols[i]; if (!key) return;
    th.style.cursor = "pointer";
    th.title = "Click to sort by this column";
    th.addEventListener("click", async () => {
      const d = await state();
      d.settings = d.settings || {};
      d.settings.sortRules = true;
      d.settings.secondarySort = key === "profile" ? "profile" : (key === "value" ? "value" : (key === "selector" ? "selector" : "site"));
      await chrome.storage.local.set({ settings: d.settings });
      await renderAll();
    });
  });
}


document.getElementById("recentWindowDays")?.addEventListener("change", async (e) => {
  const v = Math.max(1, Math.min(90, parseInt(e.target.value||"7", 10)));
  const d = await chrome.storage.local.get({ settings: {} });
  d.settings = d.settings || {};
  d.settings.recentWindowDays = v;
  await chrome.storage.local.set({ settings: d.settings });
  const s = await state();
  await renderAll();
});


// === Editing guard: pause auto-refresh & badge aging while user is typing ===
const FF_EDIT = { active:false, locks:0, pending:false, blurTimer:null, lastInput:0 };

function ffIsEditing(){
  try {
    if (FF_EDIT.locks > 0) return true;
    const ae = document.activeElement;
    if (ae && ae.matches && ae.matches('input, textarea, select, [contenteditable], [contenteditable=""], [contenteditable="true"]')) return true;
  } catch(_){}
  return !!FF_EDIT.active;
}
function ffLock(){ FF_EDIT.locks++; FF_EDIT.active = true; }
function ffUnlock(){ FF_EDIT.locks = Math.max(0, FF_EDIT.locks - 1); if (FF_EDIT.locks === 0) { FF_EDIT.active = false; if (FF_EDIT.pending) { FF_EDIT.pending = false; try { const p = renderAll(); if (p && typeof p.then==='function') p.catch(()=>{}); } catch(_) {} } } }

try {
  document.addEventListener('focusin', (e) => {
    if (e && e.target && e.target.matches && e.target.matches('input, textarea, select, [contenteditable], [contenteditable=""], [contenteditable="true"]')) {
      FF_EDIT.active = true;
    }
  });
  document.addEventListener('input', (e) => {
    if (e && e.target && e.target.matches && e.target.matches('input, textarea, select, [contenteditable], [contenteditable=""], [contenteditable="true"]')) {
      FF_EDIT.active = true;
      FF_EDIT.lastInput = Date.now();
    }
  });
  document.addEventListener('focusout', () => {
    try { clearTimeout(FF_EDIT.blurTimer); } catch(_) {}
    FF_EDIT.blurTimer = setTimeout(() => {
      try {
        const ae = document.activeElement;
        const stillEditing = !!(ae && ae.matches && ae.matches('input, textarea, select, [contenteditable], [contenteditable=""], [contenteditable="true"]'));
        FF_EDIT.active = stillEditing || (FF_EDIT.locks > 0);
        if (!FF_EDIT.active && FF_EDIT.pending) {
          FF_EDIT.pending = false;
          try { const p = renderAll(); if (p && typeof p.then==='function') p.catch(()=>{}); } catch(_) {}
        }
      } catch(_) {}
    }, 200);
  });
} catch(_) {}

// === Auto-refresh Options when data changes or tab is shown ===
(function(){
  let __ff_renderTimer = null;
  const renderSoon = () => {
    if (typeof ffIsEditing === 'function' && ffIsEditing()) { window.FF_EDIT.pending = true; return; }

    if (__ff_renderTimer) clearTimeout(__ff_renderTimer);
    __ff_renderTimer = setTimeout(() => {
      try { const p = renderAll(); if (p && typeof p.then === 'function') p.catch(()=>{}); } catch(_) {}
    }, 120);
  };

  try {
    chrome.storage.onChanged.addListener((changes, area) => {
      if (area !== 'local') return;
      if (changes.rules || changes.recentRuleTimestamps || changes.profiles || changes.settings) {
        renderSoon();
      }
    });
  } catch(_){}

  try {
    document.addEventListener('visibilitychange', () => {
      if (document.visibilityState === 'visible') renderSoon();
    });
  } catch(_){}

  try {
    chrome.runtime.onMessage.addListener((msg) => {
      if (msg && msg.type === 'FF_RULES_UPDATED') renderSoon();
    });
  } catch(_){}
})();

// === Auto-age recent badges every 60s (no storage reads) ===
function __ff_refreshRecentBadges(){
  if (typeof ffIsEditing === "function" && ffIsEditing()) return;
  try {
    const now = Date.now();
    const maxAge = (typeof RECENT_BADGE_MAX_AGE_MS !== 'undefined' && RECENT_BADGE_MAX_AGE_MS) ? RECENT_BADGE_MAX_AGE_MS : (7*24*60*60*1000);
    document.querySelectorAll('.recent-badge').forEach(el => {
      try {
        const ts = Number(el.getAttribute('data-ff-ts') || '0');
        if (!ts) return;
        const ageMs = now - ts;
        if (ageMs > maxAge) { el.remove(); return; }
        const age = fmtAge(ageMs);
        if (el.textContent !== `recent (${age})`) el.textContent = `recent (${age})`;
      } catch(_){}
    });
  } catch(_){}
}
(function(){
  try { __ff_refreshRecentBadges(); } catch(_){}
  try { setInterval(__ff_refreshRecentBadges, 60*1000); } catch(_){}
  try {
    document.addEventListener('visibilitychange', () => {
      if (document.visibilityState === 'visible') { try { __ff_refreshRecentBadges(); } catch(_){ } }
    });
  } catch(_){}
})();

// === Edit banner sync (keeps tip state correct even after long sessions) ===
window.__ff_syncEditBanner = window.__ff_syncEditBanner || function(){
  try {
    const el = document.getElementById('editStatus');
    if (!el) return;
    const editing = (typeof ffIsEditing === 'function' && ffIsEditing());
    if (editing) {
      if (!el.classList.contains('active')) el.classList.add('active');
    } else {
      if (el.classList.contains('active')) el.classList.remove('active');
    }
  } catch(_){}
};

(function(){
  try { __ff_syncEditBanner(); } catch(_){}
  try {
    if (window.FF_EDIT && !window.FF_EDIT.__bannerTimer) {
      window.FF_EDIT.__bannerTimer = setInterval(() => { try { __ff_syncEditBanner(); } catch(_){ } }, 1500);
    }
  } catch(_){}
  try {
    document.addEventListener('visibilitychange', () => {
      if (document.visibilityState === 'visible') { try { __ff_syncEditBanner(); } catch(_){ } }
    });
  } catch(_){}
})();

// === Options self-check: verify edit guard & banner sync on load / tab visible ===
(function(){
  // quiet debug helper (enable by setting window.__FF_OPT_DEBUG = true in console)
  function __ff_opt_dbg(){ if (!window.__FF_OPT_DEBUG) return; try { console.log.apply(console, arguments); } catch(_) {} }

  function __ff_installMinimalGuard(){
    try {
      // install only if missing
      if (window.ffIsEditing && window.FF_EDIT && window.FF_EDIT.__installed) return;
      window.FF_EDIT = window.FF_EDIT || {
        active:false, locks:0, pending:false, blurTimer:null, lastInput:0,
        __listeners:false, __installed:true
      };
      window.ffIsEditing = window.ffIsEditing || function(){
        try {
          if (window.FF_EDIT.locks > 0) return true;
          const ae = document.activeElement;
          if (ae && ae.matches && ae.matches('input, textarea, select, [contenteditable], [contenteditable=""], [contenteditable="true"]')) return true;
        } catch(_){}
        return !!window.FF_EDIT.active;
      };
      window.ffLock = window.ffLock || function(){ window.FF_EDIT.locks++; window.FF_EDIT.active = true; };
      window.ffUnlock = window.ffUnlock || function(){
        window.FF_EDIT.locks = Math.max(0, window.FF_EDIT.locks - 1);
        if (window.FF_EDIT.locks === 0){
          window.FF_EDIT.active = false;
          if (window.FF_EDIT.pending){
            window.FF_EDIT.pending = false;
            try { const p = renderAll(); if (p && typeof p.then === 'function') p.catch(()=>{}); } catch(_){}
          }
          try { const b=document.getElementById('editStatus'); if (b) b.classList.remove('active'); } catch(_){}
        }
      };
      if (!window.FF_EDIT.__listeners){
        try {
          document.addEventListener('focusin', (e) => {
            if (e?.target?.matches?.('input, textarea, select, [contenteditable], [contenteditable=""], [contenteditable="true"]')) {
              window.FF_EDIT.active = true;
              try { const b=document.getElementById('editStatus'); if (b) b.classList.add('active'); } catch(_){}
            }
          });
          document.addEventListener('input', (e) => {
            if (e?.target?.matches?.('input, textarea, select, [contenteditable], [contenteditable=""], [contenteditable="true"]')) {
              window.FF_EDIT.active = true;
              window.FF_EDIT.lastInput = Date.now();
              try { const b=document.getElementById('editStatus'); if (b) b.classList.add('active'); } catch(_){}
            }
          });
          document.addEventListener('focusout', () => {
            try { clearTimeout(window.FF_EDIT.blurTimer); } catch(_){}
            window.FF_EDIT.blurTimer = setTimeout(() => {
              try {
                const ae = document.activeElement;
                const still = !!(ae?.matches?.('input, textarea, select, [contenteditable], [contenteditable=""], [contenteditable="true"]'));
                window.FF_EDIT.active = still || (window.FF_EDIT.locks > 0);
                if (!window.FF_EDIT.active && window.FF_EDIT.pending){
                  window.FF_EDIT.pending = false;
                  try { const p = renderAll(); if (p && typeof p.then === 'function') p.catch(()=>{}); } catch(_){}
                }
                if (!window.FF_EDIT.active){
                  try { const b=document.getElementById('editStatus'); if (b) b.classList.remove('active'); } catch(_){}
                }
              } catch(_){}
            }, 200);
          });
        } catch(_){}
        window.FF_EDIT.__listeners = true;
      }
      __ff_opt_dbg('[FreeFiller][Options] self-check: installed minimal guard');
    } catch(_){}
  }

  window.__ff_optionsSelfCheck = window.__ff_optionsSelfCheck || function(){
    try {
      __ff_installMinimalGuard();
      // ensure banner sync is present and running
      if (typeof window.__ff_syncEditBanner === 'function') {
        try { window.__ff_syncEditBanner(); } catch(_){}
      }
      if (window.FF_EDIT && !window.FF_EDIT.__bannerTimer && typeof window.__ff_syncEditBanner === 'function'){
        try {
          window.FF_EDIT.__bannerTimer = setInterval(() => {
            try { window.__ff_syncEditBanner(); } catch(_){}
          }, 1500);
        } catch(_){}
      }
    } catch(_){}
  };

  try { window.__ff_optionsSelfCheck(); } catch(_){}
  try {
    document.addEventListener('visibilitychange', () => {
      if (document.visibilityState === 'visible') {
        try { window.__ff_optionsSelfCheck(); } catch(_){}
      }
    });
  } catch(_){}
})();

// === Snappy banner updates: event-driven sync + faster fallback (idempotent) ===
(function(){
  try {
    if (!window.__ff_syncEditBanner) return;
    if (window.FF_EDIT && !window.FF_EDIT.__bannerSyncListeners) {
      ['focusin','input','keydown','pointerdown'].forEach((ev) => {
        try {
          document.addEventListener(ev, () => { try { window.__ff_syncEditBanner(); } catch(_){} }, true);
        } catch(_) {}
      });
      window.FF_EDIT.__bannerSyncListeners = true;
    }
    if (window.FF_EDIT) {
      try { if (window.FF_EDIT.__bannerTimer) clearInterval(window.FF_EDIT.__bannerTimer); } catch(_) {}
      window.FF_EDIT.__bannerTimer = setInterval(() => {
        try { window.__ff_syncEditBanner(); } catch(_) {}
      }, 250);
    }
  } catch(_) {}
})();
// === Header layout tweak for editStatus: full-width row under title (idempotent) ===
(function(){
  try {
    if (!document.getElementById('ffHeaderStatusCSS')) {
      const st = document.createElement('style');
      st.id = 'ffHeaderStatusCSS';
      st.textContent = `
        header { flex-wrap: wrap; }
        header #editStatus { 
          display: block;
          width: 100%;
          flex-basis: 100%;
          order: 2;
          margin-top: 6px;
          text-align: left;
        }
        header .title { order: 1; }
      `;
      document.head.appendChild(st);
    }
  } catch(_){}
})();
// === Header compact spacing (idempotent override) ===
(function(){
  try {
    const id = 'ffHeaderTightCSS';
    let st = document.getElementById(id);
    if (!st) {
      st = document.createElement('style');
      st.id = id;
      document.head.appendChild(st);
    }
    st.textContent = `
      header { padding-top: 6px !important; padding-bottom: 0px !important; }
      header .title { margin: 0 !important; }
      header #editStatus { margin-bottom: 0px !important; margin-top: 2px !important; line-height: 1.25; }
    `;
  } catch(_) {}
})(); 

