async function loadState() { return chrome.storage.local.get(); }
async function refresh() {
  const s = await loadState();
  const sel = document.getElementById("profile");
  sel.innerHTML = "";
  Object.values(s.profiles || {}).forEach(p => {
    const o = document.createElement("option");
    o.value = p.id; o.textContent = p.name;
    if (p.id === s.activeProfileId) o.selected = true;
    sel.appendChild(o);
  });
  document.getElementById("autosave").checked = !!s.settings?.autoSave;
  document.getElementById("autofill").checked = !!s.settings?.autoFillOnLoad;
  document.getElementById("debug").checked = !!s.settings?.debug;
}
document.getElementById("fill").onclick = async () => {
  const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
  if (tab?.id) chrome.tabs.sendMessage(tab.id, { type: "FREEFILLER_FILL", state: await chrome.storage.local.get() });
};
document.getElementById("options").onclick = () => chrome.runtime.openOptionsPage();
document.getElementById("profile").onchange = async (e) => { await chrome.storage.local.set({ activeProfileId: e.target.value }); };
document.getElementById("autosave").onchange = async (e) => {
  const s = await chrome.storage.local.get({ settings: {} });
  s.settings.autoSave = e.target.checked; await chrome.storage.local.set({ settings: s.settings });
};
document.getElementById("autofill").onchange = async (e) => {
  const s = await chrome.storage.local.get({ settings: {} });
  s.settings.autoFillOnLoad = e.target.checked; await chrome.storage.local.set({ settings: s.settings });
};
document.getElementById("debug").onchange = async (e) => {
  const s = await chrome.storage.local.get({ settings: {} });
  s.settings.debug = e.target.checked; await chrome.storage.local.set({ settings: s.settings });
};
refresh();
